package ru.yandex.chemodan.directory.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;


@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
@NoArgsConstructor
@AllArgsConstructor
public class DirectoryOrganizationPartnerIdResponse extends DefaultObject {
    private String id;
    @JsonProperty("partner_id")
    private String partnerId;

    public Option<String> getPartnerId() {
        return Option.ofNullable(partnerId).filterNot(String::isEmpty);
    }
}
