package ru.yandex.chemodan.directory.client;

import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.misc.lang.DefaultObject;

@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class DirectoryOrganizationsResponse {
    private List<Organization> result;
    //in some cases it's object, in some - array
    // https://st.yandex-team.ru/DIR-8847
    private JsonNode links;

    @Getter
    public static class Organization extends DefaultObject {
        private String id;
    }

    public Optional<String> getNext() {
        if (links != null && links.isObject() && links.hasNonNull("next")) {
            JsonNode next = links.get("next");
            if (next != null && StringUtils.isNotBlank(next.asText())) {
                return Optional.ofNullable(next.asText());
            }
        }
        return Optional.empty();
    }
}
