package ru.yandex.chemodan.directory.client;

import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;

import ru.yandex.misc.lang.DefaultObject;

@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class DirectoryUsersResponse extends DefaultObject {
    private List<User> result;
    private Optional<Links> links;

    @Getter
    public static class User extends DefaultObject {
        private long id;
    }

    @Getter
    public static class Links extends DefaultObject {
        private String next;
    }
}
