package ru.yandex.chemodan.trust.client;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.joda.time.Instant;

public class DateAdapter {
    private static final BigDecimal MILLISECONDS_IN_SECOND = new BigDecimal(TimeUnit.SECONDS.toMillis(1));

    public static class Deserializer extends JsonDeserializer<Instant> {

        @Override
        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            BigDecimal seconds = new BigDecimal(p.getText());
            BigDecimal milliseconds = seconds.multiply(MILLISECONDS_IN_SECOND);
            return new Instant(milliseconds.longValue());
        }
    }

    public static class Serializer extends JsonSerializer<Instant> {
        @Override
        @SuppressWarnings("checkstyle:MagicNumber")
        public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            BigDecimal milliseconds = new BigDecimal(value.getMillis());

            BigDecimal seconds = milliseconds.divide(MILLISECONDS_IN_SECOND, 3, RoundingMode.HALF_DOWN);
            gen.writeString(seconds.toString());
        }
    }
}
