package ru.yandex.chemodan.trust.client;

import org.joda.time.Period;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;

public class DurationUtils {

    public static Period parsePeriod(String trustPeriod) {
        if (trustPeriod.length() < 2) {
            throw new IllegalArgumentException(trustPeriod);
        }

        String periodName = trustPeriod.substring(trustPeriod.length() - 1);
        String count = trustPeriod.substring(0, trustPeriod.length() - 1);
        Option<TrustPeriod> periodO = TrustPeriod.PERIODS_MAP.getO(periodName);
        TrustPeriod period =
                periodO.getOrThrow(() -> new IllegalArgumentException("unknown period name :" + periodName));
        int countParsed = Integer.parseInt(count);
        return period.getPeriod().multipliedBy(countParsed);
    }

    private enum TrustPeriod {
        YEAR("Y", Period.years(1)),
        WEEK("W", Period.weeks(1)),
        DAY("D", Period.days(1)),
        MONTH("M", Period.months(1)),
        SECOND("S", Period.seconds(1));

        public static MapF<String, TrustPeriod> PERIODS_MAP =
                Cf.x(values()).toMap(TrustPeriod::getText, Function.identityF());

        private String text;
        private Period period;

        TrustPeriod(String text, Period period) {
            this.text = text;
            this.period = period;
        }

        public String getText() {
            return text;
        }

        public Period getPeriod() {
            return period;
        }
    }
}
