package ru.yandex.chemodan.trust.client;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.http.HttpStatus;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.trust.client.responses.BasicResponse;
import ru.yandex.misc.lang.StringUtils;

@Getter
@AllArgsConstructor
public class TrustException extends RuntimeException {
    private Option<HttpStatus> httpCode = Option.empty();
    private String status;
    private String statusCode;
    private String statusDesc;

    public TrustException(String message) {
        super(message);
    }

    public TrustException(Option<HttpStatus> httpCode, BasicResponse result) {
        this(result == null ? "Empty result from Trust" : result.getStatus() +
                (StringUtils.isNotBlank(result.getStatusCode()) ? ":" + result.getStatusCode() : "") +
                (StringUtils.isNotBlank(result.getStatusDesc()) ? " " + result.getStatusDesc() : ""));
        this.httpCode = httpCode;
        if (result != null) {
            status = result.getStatus();
            statusCode = result.getStatusCode();
            statusDesc = result.getStatusDesc();
        }
    }

    public TrustException(String message, Throwable cause) {
        super(message, cause);
    }
}
