package ru.yandex.chemodan.trust.client.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;

import ru.yandex.inside.passport.PassportUid;

@Getter
public abstract class AbstractUserRequest extends TrustRequest {
    @JsonIgnore
    private PassportUid uid;
    @JsonIgnore
    private String userIp;
    @JsonIgnore
    private String regionId;

    public AbstractUserRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId) {
        super(trustServiceId);
        this.uid = uid;
        this.userIp = userIp;
        this.regionId = regionId;
    }
}
