package ru.yandex.chemodan.trust.client.requests;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.inside.passport.PassportUid;

@Getter
public class CreateOrderRequest extends AbstractUserRequest {
    @JsonProperty("order_id")
    private String orderId;
    @JsonProperty("product_id")
    private String productId;
    @JsonProperty("developer_payload")
    private Map<String, Object> developerPayload;

    @Builder
    public CreateOrderRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId,
            String orderId, String productId, Map<String, Object> developerPayload)
    {
        super(trustServiceId, uid, userIp, regionId);
        this.orderId = orderId;
        this.productId = productId;
        this.developerPayload = developerPayload;
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
