package ru.yandex.chemodan.trust.client.requests;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.inside.passport.PassportUid;

@Getter
public class CreatePaymentRequest extends AbstractUserRequest {
    @JsonProperty("paymethod_id")
    private String paymentMethod;
    @JsonProperty("orders")
    private List<PaymentOrder> orders;
    @JsonProperty("back_url")
    private String notificationUrl;
    @JsonProperty("return_path")
    private String returnPath;
    @JsonProperty("lang")
    private String lang;
    @JsonProperty("domain_sfx")
    private String domainSuffix;
    @JsonProperty("template_tag")
    private String templateTag;
    @JsonProperty("currency")
    private String currency;
    @JsonProperty("developer_payload")
    private String developerPayload;
    @JsonProperty("afs_params")
    private AfsParams afsParams;

    @Builder
    public CreatePaymentRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId,
                                String paymentMethod, List<PaymentOrder> orders, String notificationUrl,
                                String returnPath,
                                String lang, String domainSuffix, String templateTag, String currency,
                                String developerPayload, AfsParams afsParams) {
        super(trustServiceId, uid, userIp, regionId);
        this.paymentMethod = paymentMethod;
        this.orders = orders;
        this.notificationUrl = notificationUrl;
        this.returnPath = returnPath;
        this.lang = lang;
        this.domainSuffix = domainSuffix;
        this.templateTag = templateTag;
        this.currency = currency;
        this.developerPayload = developerPayload;
        this.afsParams = afsParams;
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
