package ru.yandex.chemodan.trust.client.requests;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.misc.lang.Validate;

@Getter
public class CreateProductRequest extends TrustRequest {
    @JsonProperty("name")
    private final String name;
    @JsonProperty("local_names")
    private final List<LocalName> localNames;
    @JsonProperty("prices")
    private final List<Price> prices;
    @JsonProperty("subs_start_period_prices") //цена скидочного периода
    private final List<Price> startPeriodPrices;
    @JsonProperty("product_id")
    private final String productId;
    @JsonProperty("product_type")
    private final String productType;
    @JsonProperty("parent_service_product_id")
    private final String parentProductId;

    @JsonProperty("fiscal_nds")
    private final String fiscalNds;
    @JsonProperty("fiscal_title")
    private final String fiscalTitle;

    @JsonProperty("subs_period")
    private final String subscriptionPeriod;
    @JsonProperty("subs_retry_charging_delay") // Интервал между попытками списания
    private final String subscriptionRetryChargingDelay;
    @JsonProperty("subs_retry_charging_limit")
    //  Период, в течение которого нужно делать попытки списания за подписку
    private final String subscriptionRetryChargingLimit;
    @JsonProperty("subs_grace_period")
    private final String subscriptionGracePeriod;
    @JsonProperty("subs_trial_period")
    private final String subscriptionTrialPeriod;
    @JsonProperty("single_purchase")
    private final Integer singlePurchase;
    @JsonProperty("subs_trial_repeat")
    private final Integer subsTrialRepeat;
    @JsonProperty("package_name")
    private final String packageName;
    @JsonProperty("subs_start_period")
    private final String subscriptionStartPeriod;
    @JsonProperty("subs_start_period_qty")
    private final Integer subscriptionStartPeriodCount;

    @Builder
    public CreateProductRequest(Integer trustServiceId, String name,
                                List<LocalName> localNames, List<Price> prices, List<Price> startPeriodPrices, String productId, String productType,
                                String parentProductId, String fiscalNds, String fiscalTitle, String subscriptionPeriod,
                                String subscriptionRetryChargingDelay, String subscriptionRetryChargingLimit, Integer subsTrialRepeat,
                                String subscriptionGracePeriod, String subscriptionTrialPeriod, Integer singlePurchase, String packageName, String subscriptionStartPeriod, Integer subscriptionStartPeriodCount)
    {
        super(trustServiceId);
        this.name = name;
        this.localNames = localNames;
        this.prices = prices;
        this.startPeriodPrices = startPeriodPrices;
        this.productId = productId;
        this.productType = productType;
        this.parentProductId = parentProductId;
        this.fiscalNds = fiscalNds;
        this.fiscalTitle = fiscalTitle;
        this.subscriptionPeriod = subscriptionPeriod;
        this.subscriptionRetryChargingDelay = subscriptionRetryChargingDelay;
        this.subscriptionRetryChargingLimit = subscriptionRetryChargingLimit;
        this.subscriptionGracePeriod = subscriptionGracePeriod;
        this.subscriptionTrialPeriod = subscriptionTrialPeriod;
        this.singlePurchase = singlePurchase;
        this.subsTrialRepeat = subsTrialRepeat;
        this.packageName = packageName;
        this.subscriptionStartPeriod = subscriptionStartPeriod;
        this.subscriptionStartPeriodCount = subscriptionStartPeriodCount;
        //all null or none null
        if (!((subscriptionStartPeriodCount == null && startPeriodPrices == null && subscriptionStartPeriod == null)
        || (subscriptionStartPeriodCount != null && startPeriodPrices != null && subscriptionStartPeriod != null))) {
            Validate.fail("Subscription start period properties must be null all or none");
        }
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
