package ru.yandex.chemodan.trust.client.requests;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;

import ru.yandex.inside.passport.PassportUid;


public class CreateRefundRequest extends AbstractUserRequest {
    @JsonProperty("reason_desc")
    private String reasonDesc;
    @JsonProperty("purchase_token")
    private String purchaseToken;
    @JsonProperty("orders")
    private List<OrderToRefund> orders;

    @Builder
    public CreateRefundRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId,
            String reasonDesc, String purchaseToken,
            List<OrderToRefund> orders)
    {
        super(trustServiceId, uid, userIp, regionId);
        this.reasonDesc = reasonDesc;
        this.purchaseToken = purchaseToken;
        this.orders = orders;
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
