package ru.yandex.chemodan.trust.client.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.inside.passport.PassportUid;

@Getter
public class PaymentRequest extends AbstractUserRequest {
    @JsonIgnore
    private String purchaseToken;

    @Builder
    public PaymentRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId,
            String purchaseToken)
    {
        super(trustServiceId, uid, userIp, regionId);
        this.purchaseToken = purchaseToken;
    }

    @Override
    public Object toRequestBody() {
        return null;
    }
}
