package ru.yandex.chemodan.trust.client.requests;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.trust.client.DateAdapter;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
public class Price extends DefaultObject {
    @JsonProperty("region_id")
    private String region;
    @JsonProperty("start_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant date;
    @JsonProperty("price")
    private BigDecimal price;
    @JsonProperty("currency")
    private String currency;
}
