package ru.yandex.chemodan.trust.client.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.chemodan.trust.client.InappStoreType;
import ru.yandex.inside.passport.PassportUid;

@Getter
public class SendInappReceiptRequest extends AbstractUserRequest {
    @JsonProperty("store_id")
    private final String storeId;
    @JsonProperty("receipt")
    private final String receipt;
    @JsonProperty("currency")
    private final String currency;

    @Builder
    public SendInappReceiptRequest(Integer trustServiceId, PassportUid uid,
            String userIp, String regionId, InappStoreType storeId, String receipt, String currency)
    {
        super(trustServiceId, uid, userIp, regionId);
        this.storeId = storeId.name();
        this.receipt = receipt;
        this.currency = currency;
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
