package ru.yandex.chemodan.trust.client.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.trust.client.DateAdapter;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author friendlyevil
 */
@Getter
public class SupplementRequest extends AbstractUserRequest {
    @JsonIgnore
    private String orderId;

    @JsonProperty("expected_subs_until_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant expectedSubsUntilTs;

    @JsonProperty("supplement_until_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant supplementUntilTs;

    @Builder
    public SupplementRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId, String orderId,
                             Instant expectedSubsUntilTs, Instant supplementUntilTs) {
        super(trustServiceId, uid, userIp, regionId);
        this.orderId = orderId;
        this.expectedSubsUntilTs = expectedSubsUntilTs;
        this.supplementUntilTs = supplementUntilTs;
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
