package ru.yandex.chemodan.trust.client.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.trust.client.DateAdapter;
import ru.yandex.inside.passport.PassportUid;

@Getter
public class UpdateSubscriptionRequest extends AbstractUserRequest {
    @JsonIgnore
    private String orderId;
    @JsonProperty("finish_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant finishTime;
    @JsonProperty("trial_until_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant trialStopTime;

    @Builder
    public UpdateSubscriptionRequest(Integer trustServiceId, PassportUid uid, String userIp, String regionId,
            String orderId, Instant finishTime, Instant trialStopTime)
    {
        super(trustServiceId, uid, userIp, regionId);
        this.orderId = orderId;
        this.finishTime = finishTime;
        this.trialStopTime = trialStopTime;
    }

    @Override
    public Object toRequestBody() {
        return this;
    }
}
