package ru.yandex.chemodan.trust.client.responses;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * Raw appleStore reciept based on https://developer.apple.com/documentation/appstorereceipts/responsebody/receipt
 * contains only required fields can be expanded if required
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class AppleReceiptResponse extends BasicResponse {
    @JsonProperty("result")
    private Result result;

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Result extends DefaultObject {
        @JsonProperty("receipt_info")
        private ReceiptInfo receiptInfo;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ReceiptInfo extends DefaultObject {
        @JsonProperty("receipt")
        private Receipt receipt;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Receipt extends DefaultObject {
        @JsonProperty("in_app")
        private ListF<InAppPurchase> inAppPurchases;

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Setter
    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InAppPurchase extends DefaultObject {
        @JsonProperty("original_transaction_id")
        private String originalTransactionId;
        @JsonProperty("is_trial_period")
        private Boolean isTrialPeriod;
        @JsonProperty("is_in_intro_offer_period")
        private Boolean isInIntroOfferPeriod;
        @JsonProperty("product_id")
        private String productId;

    }
}
