package ru.yandex.chemodan.trust.client.responses;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GetPaymentMethodsResponse extends BasicResponse {

    @JsonProperty("bound_payment_methods")
    List<PaymentMethod> paymentMethods;

    private MapF<String, Object> otherAttributes = Cf.hashMap();

    @JsonAnySetter
    public void addAttribute(String name, Object value) {
        otherAttributes.put(name, value);
    }

    @JsonAnyGetter
    public MapF<String, Object> getOtherAttributes() {
        return otherAttributes;
    }

}
