package ru.yandex.chemodan.trust.client.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.chemodan.trust.client.InappStoreType;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InappSubscription extends DefaultObject {
    @JsonProperty("uid")
    private String uid;
    @JsonProperty("sync_dt")
    private Instant syncTime;
    @JsonProperty("store_expiration_dt")
    private Instant storeExpirationTime;
    @JsonProperty("state")
    private InappSubscriptionState state;
    @JsonProperty("product_id")
    private String productId;
    @JsonProperty("subs_until_dt")
    private Instant subscriptionUntil;
    @JsonProperty("store_subscription_id")
    private String storeSubscriptionId;
    @JsonProperty("id")
    private String subscriptionId;
    @JsonProperty("store_id")
    private InappStoreType storeType;
}
