package ru.yandex.chemodan.trust.client.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.chemodan.trust.client.DateAdapter;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class InstantInterval extends DefaultObject {
    @JsonProperty("begin_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant from;
    @JsonProperty("until_ts")
    @JsonSerialize(using = DateAdapter.Serializer.class)
    @JsonDeserialize(using = DateAdapter.Deserializer.class)
    private Instant to;
}
