package ru.yandex.chemodan.trust.client.responses;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@ToString
public class PaymentMethod {
    private MapF<String, Object> otherAttributes = Cf.hashMap();

    @JsonProperty("region_id")
    Integer regionId;
    @JsonProperty("payment_method")
    String paymentMethod;
    @JsonProperty("payment_system")
    String paymentSystem;
    @JsonProperty("id")
    String id;
    @JsonProperty("account")
    String account;
    @JsonProperty("expired")
    boolean expired;

    @JsonAnySetter
    public void addAttribute(String name, Object value) {
        otherAttributes.put(name, value);
    }

    @JsonAnyGetter
    public MapF<String, Object> getOtherAttributes() {
        return otherAttributes;
    }

    public String getFormattedName() {
        return paymentSystem + " " + (account.length() > 4 ? account.substring(account.length()-4) : account);
    }
}
