package ru.yandex.chemodan.trust.client.responses;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PaymentResponse extends BasicResponse {
    @JsonProperty("purchase_token")
    private String purchaseToken;
    @JsonProperty("payment_url")
    private String paymentUrl;
    @JsonProperty("payment_status")
    private PaymentStatus paymentStatus;
    @JsonProperty("payment_resp_code")
    private String paymentStatusCode;
    @JsonProperty("payment_resp_desc")
    private String paymentStatusDescription;
    @JsonProperty("current_amount")
    private BigDecimal currentAmount;
    @JsonProperty("amount")
    private BigDecimal amount;
    @JsonProperty("paymethod_id")
    private String paymethodId;
    @JsonProperty("binding_result")
    private String bindingResult;

    private MapF<String, Object> otherAttributes = Cf.hashMap();

    @JsonAnySetter
    public void addAttribute(String name, Object value) {
        otherAttributes.put(name, value);
    }

    @JsonAnyGetter
    public MapF<String, Object> getOtherAttributes() {
        return otherAttributes;
    }

}
