package ru.yandex.chemodan.trust.client.responses;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;

public enum PaymentStatus {
    started,
    not_started,
    authorized,
    not_authorized,
    cleared,
    cancelled,
    refunded,
    @JsonEnumDefaultValue
    unknown;

    public boolean isSuccessful() {
        return this == authorized || this == cleared;
    }

    public boolean isRefunded() {
        return this == cancelled || this == refunded;
    }

}
