package ru.yandex.chemodan.trust.client.responses;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import org.apache.commons.lang3.EnumUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;

public enum TrustRefundStatus {
    success,
    error, //unknown error, retry is prohibited
    failed, // retry allowed
    wait_for_notification,
    @JsonEnumDefaultValue
    unknown;

    public static Option<TrustRefundStatus> parse(String value) {
        return Cf.x(EnumUtils.getEnumMap(TrustRefundStatus.class)).getO(value);
    }
}
