package ru.yandex.chemodan.app.psbilling.web.actions;

import java.io.IOException;

import lombok.AllArgsConstructor;
import org.springframework.util.StreamUtils;

import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationService;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@ActionContainer
@AllArgsConstructor
public class DirectoryActions {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryActions.class);

    private final GroupServicesActualizationService groupServicesActualizationService;

    @Path(value = "/v1/directory/userUpdated", methods = HttpMethod.POST)
    @WithMasterSlavePolicy(MasterSlavePolicy.R_M)
    public void userUpdated(@SpecialParam HttpServletRequestX request) throws IOException {
        String body = StreamUtils.copyToString(request.getInputStreamX(), CharsetUtils.UTF8_CHARSET);
        String xOrgId = request.getHeader("X-Org-ID");
        logger.info("userUpdated event, header X-Org-ID {}, body {}", xOrgId, body);

        groupServicesActualizationService.scheduleForceGroupActualization(GroupType.ORGANIZATION, xOrgId);
    }
}
