package ru.yandex.chemodan.app.psbilling.web.actions;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.web.model.PromoPayloadPojo;
import ru.yandex.chemodan.boot.admin.idm.IdmAdminRolesService;
import ru.yandex.chemodan.util.auth.YateamAuthUtils;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.chemodan.web.EmptyPojo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.BoundByJackson;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@ActionContainer
@AllArgsConstructor
public class PromoAdminActions {
    private static final Logger logger = LoggerFactory.getLogger(MailSupportActions.class);

    private final PromoService promoService;

    @Path(value = "/v1/admin/promo/{promoKey}/payload", methods = HttpMethod.PUT)
    @WithMasterSlavePolicy(MasterSlavePolicy.R_M)
    public EmptyPojo setPayload(@SpecialParam HttpServletRequestX reqX,
                                @PathParam("promoKey") String promoKey,
                                @RequestParam("payloadType") String promoPayloadType,
                                @RequestParam(value = "payloadVersion", required = false) Option<Integer> promoPayloadVersion,
                                @BoundByJackson PromoPayloadPojo promoPayload) {
        String internalLogin = YateamAuthUtils.getLoginFromAttributeO(reqX).orElseThrow(
                () -> new RuntimeException("Not authorized"));

        logger.info("setPayload login: {}, promo: {}, " +
                        "payloadType: {}, payloadVersion: {}",
                internalLogin, promoKey, promoPayloadType, promoPayloadVersion);

        String idmRole = "PROMO";
        if (!IdmAdminRolesService.getRoles(reqX).contains(idmRole)) {
            throw new A3ExceptionWithStatus("Missing IDM role: " + idmRole, HttpStatus.SC_403_FORBIDDEN);
        }

        String promoPayloadContent = promoPayload.getPayload().orElseThrow();
        promoService.setPayload(promoKey, promoPayloadType,
                promoPayloadVersion.orElse(0), promoPayloadContent);

        return EmptyPojo.INSTANCE;
    }
}
