package ru.yandex.chemodan.app.psbilling.web.actions.groups;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.web.exceptions.WebActionException;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToPassportUid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
@AllArgsConstructor
public class OrganizationActions {
    private final GroupsManager groupsManager;
    private final DirectoryService directoryService;

    @Path(value = "/v1/groups/organization/admins/{uid}/features")
    @WithMasterSlavePolicy(MasterSlavePolicy.R_SYNC_SM)
    public MapF<String, Boolean> getOrganizationsFeaturesForAdmin(
            @PathParam(value = "uid", customConverter = ConverterToPassportUid.class) PassportUid uid,
            @RequestParam("service") String service) {
        //один большой костыль (хотя бы локализован весь здесь). Пока не знаем, как в итоге оформим этот функционал
        if (service.equals("mail") || service.equals("disk")) {
            ListF<String> organizations = directoryService.organizationsWhereUserIsAdmin(uid);
            SetF<String> subscribedGroupProductCodes =
                    groupsManager.findSubscribedGroupProductCodes(GroupType.ORGANIZATION, organizations);
            switch (service) {
                case "mail":
                    return Cf.map("mail_priority_support", subscribedGroupProductCodes.containsTs("org_mail_pro_v1"));
                case "disk":
                    return Cf.map("disk_priority_support", subscribedGroupProductCodes.containsTs("org_disk_2tb_v1"));
                default:
                    throw WebActionException.cons400("Supported only service=mail|disk");
            }
        } else {
            throw WebActionException.cons400("Supported only service=mail|disk");
        }
    }
}
