package ru.yandex.chemodan.app.psbilling.web.actions.promos;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.promo.PromoActivationPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.web.model.PromoActivationResultPojo;
import ru.yandex.chemodan.app.psbilling.web.model.PromoListResponsePojo;
import ru.yandex.chemodan.app.psbilling.web.services.PromoPojoService;
import ru.yandex.chemodan.util.web.Tvm2UidParameterBinder;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.security.UnauthorizedException;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@ActionContainer
@AllArgsConstructor
public class PromoActions {
    private static final Logger logger = LoggerFactory.getLogger(PromoActions.class);
    private final PromoService promoService;
    private final PromoActivationPreExecutionPolicy promoActivationPreExecutionPolicy;
    private final PromoPojoService promoPojoService;

    @Path(value = "/v1/promo/{promoKey}/activate", methods = HttpMethod.POST)
    @WithMasterSlavePolicy(MasterSlavePolicy.R_M)
    public PromoActivationResultPojo activate(@BindWith(Tvm2UidParameterBinder.class) PassportUidOrZero uid,
                                              @PathParam("promoKey") String promoKey,
                                              @RequestParam(value = "activateIfUsed", required = false) boolean activateIfUsed,
                                              @RequestParam(value = "sendEmail", required = false) boolean sendEmail) {
        logger.info("activate-> uid={}, promo_key={}, sendEmail={}", uid, promoKey, sendEmail);
        if (!uid.isAuthenticated()) {
            throw new UnauthorizedException("uid isn't specified");
        }

        boolean activated = promoActivationPreExecutionPolicy.shouldActivate(uid.toPassportUid(), promoKey,
                activateIfUsed) &&
                promoService.activatePromoForUser(uid.toPassportUid(), promoKey, activateIfUsed, sendEmail);

        return new PromoActivationResultPojo(activated);
    }

    @Path(value = "/v1/promo/future", methods = HttpMethod.GET)
    @WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
    public PromoListResponsePojo getFuturePromos(@BindWith(Tvm2UidParameterBinder.class) PassportUidOrZero uid,
                                                 @RequestParam(value = "lang", required = false) String language,
                                                 @RequestParam(value = "payloadType", required = false) Option<String> promoPayloadType,
                                                 @RequestParam(value = "payloadVersion", required = false) Option<Integer> promoPayloadVersion
    ) {
        logger.info("list future-> uid={}, lang={}, payloadType={}, payloadVersion={}", uid, language,
                promoPayloadType, promoPayloadVersion);

        return new PromoListResponsePojo(
                promoPojoService.createPromosPojo(promoService.getFuturePromos(uid.toPassportUidO()), language,
                        promoPayloadType, promoPayloadVersion)
        );
    }
}
