package ru.yandex.chemodan.app.psbilling.web.actions.users;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductOwner;
import ru.yandex.chemodan.app.psbilling.core.entities.users.Order;
import ru.yandex.chemodan.app.psbilling.core.products.ExperimentalProductFeature;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.chemodan.app.psbilling.core.users.UserService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.psbilling.web.model.OrderStatusApi;
import ru.yandex.chemodan.app.psbilling.web.model.OrderTypeApi;
import ru.yandex.chemodan.app.psbilling.web.model.ServiceStatusFilter;
import ru.yandex.chemodan.app.psbilling.web.model.UserServicePojo;
import ru.yandex.chemodan.app.psbilling.web.model.UserServicesPojo;
import ru.yandex.chemodan.app.psbilling.web.services.ProductsService;
import ru.yandex.inside.passport.PassportUidOrZero;


/**
 * @author yashunsky
 */
@AllArgsConstructor
public class UserBillingActionsHelper {
    private final UserServiceManager userServiceManager;
    private final ProductsService productsService;

    public UserServicesPojo getUserServices(
            PassportUidOrZero uid, Option<ProductOwner> productOwner, String language,
            ListF<ExperimentalProductFeature> expFeatures, ServiceStatusFilter... statuses) {
        MapF<UUID, UserService> userServices;
        if (statuses.length == 0) {
            userServices = userServiceManager.find(uid.toPassportUid().toString(),
                    productOwner.map(ProductOwner::getId), Option.empty(), Option.empty())
                    .toMap(UserService::getId, us -> us);
        } else {
            userServices = Cf.hashMap();
            for (ServiceStatusFilter status : statuses) {
                userServiceManager.find(uid.toPassportUid().toString(), productOwner.map(ProductOwner::getId),
                        Option.of(status.getServiceTarget()), status.getOrderStatusFilter())
                        .forEach(us -> userServices.put(us.getId(), us));
            }
        }
        //остаться должен только один сервис на заказ
        MapF<UserService, OrderStatusApi> serviceStatuses = Cf.hashMap();
        MapF<UserService, OrderTypeApi> orderTypes = Cf.hashMap();
        for (UserService service : userServices.values()) {
            Option<Order> order = userServiceManager.findLastPaymentOrder(service);
            //default
            orderTypes.put(service, OrderTypeApi.UNSPECIFIED);

            if (order.isPresent()) {
                order.get().getUserServiceId().ifPresent(serviceId -> {
                    if (serviceId.equals(service.getId())) {
                        serviceStatuses.put(service, OrderStatusApi.fromCoreEnum(order.get().getStatus()));
                        orderTypes.put(service, OrderTypeApi.fromCoreEnum(order.get().getType()));
                    }
                });
                //no order but service enabled. add too
            } else if (service.getTarget().equals(Target.ENABLED)) {
                serviceStatuses.put(service, OrderStatusApi.PAID);
            }
        }
        return new UserServicesPojo(
                serviceStatuses.keys().filterMap(us -> productsService
                        .mapBoughtProduct(us, language, expFeatures)
                        .map(product -> new UserServicePojo(
                                us,
                                serviceStatuses.getTs(us),
                                orderTypes.getTs(us),
                                product,
                                productsService.mapNextPayment(us)))
                )
        );
    }
}
