package ru.yandex.chemodan.app.psbilling.web.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.web.utils.ExcludeByRegExpTmvFilter;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.inside.passport.tvm2.web.Tvm2CheckingMode;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.parse.CommaSeparated;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@Configuration
@Import(Tvm2BaseContextConfiguration.class)
public class ExcludeByRegExpTvm2FilterConfiguration {
    private final static Logger logger = LoggerFactory.getLogger(ExcludeByRegExpTvm2FilterConfiguration.class);

    public final static String X_UID = "X-Uid";

    @Bean
    @Primary
    protected Tvm2Filter internalAccessFilter(
            @Value("${tvm.filter.mode:-DISABLED}") Tvm2CheckingMode tvm2Mode,
            @Value("${tvm.filter.pattern:-*}") String tvm2ServletUrlPattern,
            @Value("${tvm.filter.uid.param:-__uid}") String uidParamName,
            @Value("${tvm.filter.excluded-regexp-paths:-}") CommaSeparated excludedPaths,
            Tvm2 tvm2)
    {
        if (tvm2 == null || tvm2Mode == Tvm2CheckingMode.DISABLED) {
            logger.warn("Tvm is not initialised or disabled, validation will be skipped");
            Validate.isTrue(tvm2Mode != Tvm2CheckingMode.FULL,
                    "Tvm is required by tvm2Mode property: " + tvm2Mode);
            return null;
        }
        logger.info("About to start filter with mode: {}, pattern: {}, uid: {}",
                tvm2Mode, tvm2ServletUrlPattern, uidParamName);
        ListF<Function<HttpServletRequestX, Option<String>>> uidFetchers = Cf.list(
                requestX -> requestX.getHeaderO(X_UID),
                requestX -> requestX.getParameterO(uidParamName)
        );
        return new ExcludeByRegExpTmvFilter(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers, excludedPaths.list);
    }
}
