package ru.yandex.chemodan.app.psbilling.web.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.psbilling.web.exceptions.BalanceExceptionHandler;
import ru.yandex.chemodan.app.psbilling.web.ratelimiter.PsBillingRateLimiterInterceptor;
import ru.yandex.chemodan.app.psbilling.web.ratelimiter.RateLimiterConfiguration;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.admin.idm.DefaultIdmInterceptorContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.chemodan.web.ClientInfoAndUidFromTvmInterceptor;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.chemodan.web.JacksonMapResultSerializer;
import ru.yandex.chemodan.web.JacksonPojoResultSerializer;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.parameter.bind.JacksonParameterBinder;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;

@Configuration
@Import({
        RateLimiterConfiguration.class,
        A3JettyContextConfiguration.class,
        ZkTvm2ContextConfiguration.class,
        JacksonContextConfiguration.class,
        ExcludeByRegExpTvm2FilterConfiguration.class,
        ChemodanCommonContextConfiguration.class,
        DefaultIdmInterceptorContextConfiguration.class,
        PsBillingWebActionsHelpersConfiguration.class,
        PsBillingWebCoreConfiguration.class,
        PsBillingClientInfoAndUidInterceptorsContextConfiguration.class
})
public class PsBillingWebActionsConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(
                Tuple2List.fromPairs("/*", "")
        );
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context,
                               ApplicationInfo applicationInfo,
                               ObjectMapper objectMapper,
                               PsBillingRateLimiterInterceptor rateLimiterInterceptor,
                               ClientInfoAndUidFromTvmInterceptor clientInfoAndUidFromTvmInterceptor) {
        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator.getBuilder()
                .addInvocationInterceptors(Cf.list(
                                new AddCommonAttributesInterceptor(applicationInfo),
                                new ThreadLocalCacheInterceptor(),
                                rateLimiterInterceptor))
                .addParameterBinders(Cf.list(new JacksonParameterBinder(objectMapper)))
                .addExceptionHandlers(Cf.list(new BalanceExceptionHandler()))
                .addResultSerializers(Cf.list(
                        new JacksonPojoResultSerializer(objectMapper), new JacksonMapResultSerializer(objectMapper)
                ))
                .addDispatcherInterceptors(Cf.list(clientInfoAndUidFromTvmInterceptor));

        return configurator.configure();
    }
}
