package ru.yandex.chemodan.app.psbilling.web.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.CardBindingChecker;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.CardDao;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.TrustCardBindingDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServicePriceOverrideDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.billing.ClientBalanceDao;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.promocodes.PromoCodeService;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.psbilling.core.util.LanguageService;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.GroupActionsHelper;
import ru.yandex.chemodan.app.psbilling.web.actions.users.UserBillingActionsHelper;
import ru.yandex.chemodan.app.psbilling.web.services.ProductsService;

/**
 * @author yashunsky
 */
@Configuration
@Import(PsBillingWebServicesConfiguration.class)
public class PsBillingWebActionsHelpersConfiguration {
    @Bean
    public GroupActionsHelper groupActionsHelper(
            GroupServicesManager groupServicesManager,
            GroupsManager groupsManager,
            GroupProductManager groupProductManager,
            GroupServicePriceOverrideDao groupServicePriceOverrideDao,
            ProductsService productsService,
            BalanceService balanceService,
            GroupBillingService groupBillingService,
            FeatureFlags featureFlags,
            ClientBalanceDao clientBalanceDao,
            TaskScheduler taskScheduler,
            CardDao cardDao,
            TrustCardBindingDao trustCardBindingDao,
            CardBindingChecker cardBindingChecker,
            LanguageService languageService,
            PromoCodeService promoCodeService
    ) {
        return new GroupActionsHelper(
                groupServicesManager,
                groupsManager,
                groupProductManager,
                groupServicePriceOverrideDao,
                productsService,
                balanceService,
                groupBillingService,
                featureFlags,
                clientBalanceDao,
                taskScheduler,
                cardDao,
                trustCardBindingDao,
                cardBindingChecker,
                languageService,
                promoCodeService);
    }

    @Bean
    public UserBillingActionsHelper userBillingActionsHelper(UserServiceManager userServiceManager,
                                                             ProductsService productsService) {
        return new UserBillingActionsHelper(userServiceManager, productsService);
    }
}
