package ru.yandex.chemodan.app.psbilling.web.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupServiceTransactionsCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.PaymentChecker;
import ru.yandex.chemodan.app.psbilling.core.billing.users.ReceiptHandlerV1;
import ru.yandex.chemodan.app.psbilling.core.billing.users.ReceiptHandlerV2;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.config.UserServicesConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.config.tasks.TaskBeansConfiguration;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductOwnerDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.groups.OptionalFeaturesManager;
import ru.yandex.chemodan.app.psbilling.core.promocodes.PromoCodeService;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.promo.PromoActivationPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.psbilling.web.actions.DirectoryActions;
import ru.yandex.chemodan.app.psbilling.web.actions.MailSupportActions;
import ru.yandex.chemodan.app.psbilling.web.actions.PromoAdminActions;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.GroupActions;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.GroupActionsHelper;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.GroupAgreementsActions;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.GroupBillingActions;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.GroupPromoCodeActions;
import ru.yandex.chemodan.app.psbilling.web.actions.groups.OrganizationActions;
import ru.yandex.chemodan.app.psbilling.web.actions.promos.PromoActions;
import ru.yandex.chemodan.app.psbilling.web.actions.promos.PromoCodeActions;
import ru.yandex.chemodan.app.psbilling.web.actions.users.UserBillingActions;
import ru.yandex.chemodan.app.psbilling.web.actions.users.UserBillingActionsHelper;
import ru.yandex.chemodan.app.psbilling.web.actions.users.UserProductActions;
import ru.yandex.chemodan.app.psbilling.web.converter.ToPromoCodeActivatedRsPojo;
import ru.yandex.chemodan.app.psbilling.web.services.PaymentDataService;
import ru.yandex.chemodan.app.psbilling.web.services.ProductsService;
import ru.yandex.chemodan.app.psbilling.web.services.PromoPojoService;
import ru.yandex.chemodan.app.psbilling.web.services.SubscriptionService;
import ru.yandex.chemodan.app.psbilling.web.validation.GroupAdminPermissionValidation;
import ru.yandex.chemodan.app.psbilling.web.validation.GroupValidator;
import ru.yandex.chemodan.directory.client.DirectoryClient;

@Configuration
@Import({
        PsBillingWebServicesConfiguration.class,
        PsBillingWebActionsHelpersConfiguration.class,
        TaskBeansConfiguration.class,
        UserServicesConfiguration.class
})
public class PsBillingWebCoreConfiguration {
    @Bean
    public OrganizationActions organizationActions(GroupsManager groupsManager, DirectoryService directoryService) {
        return new OrganizationActions(groupsManager, directoryService);
    }

    @Bean
    public GroupActions groupActions(
            GroupsManager groupsManager,
            GroupActionsHelper groupActionsHelper,
            OptionalFeaturesManager optionalFeaturesManager,
            GroupAdminPermissionValidation groupAdminPermissionValidation,
            GroupValidator groupValidator) {
        return new GroupActions(
                groupsManager,
                groupActionsHelper,
                optionalFeaturesManager,
                groupAdminPermissionValidation,
                groupValidator);
    }

    @Bean
    public GroupBillingActions groupBillingActions(
            GroupsManager groupsManager,
            SubscriptionService subscriptionService,
            GroupBillingService groupBillingService,
            GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService,
            PaymentDataService paymentDataService,
            ProductOwnerDao productOwnerDao,
            PaymentChecker paymentChecker,
            GroupAdminPermissionValidation groupAdminPermissionValidation,
            GroupValidator groupValidator) {
        return new GroupBillingActions(
                groupsManager,
                groupBillingService,
                groupServiceTransactionsCalculationService,
                subscriptionService,
                paymentDataService,
                productOwnerDao,
                paymentChecker,
                groupAdminPermissionValidation,
                groupValidator);
    }

    @Bean
    public GroupAgreementsActions groupAgreementsActions(GroupsManager groupsManager,
                                                         GroupAdminPermissionValidation validation) {
        return new GroupAgreementsActions(groupsManager, validation);
    }

    @Bean
    public GroupPromoCodeActions groupPromoCodeActions(
            GroupAdminPermissionValidation groupAdminPermissionValidation,
            PromoCodeService promoCodeService,
            GroupsManager groupsManager,
            ToPromoCodeActivatedRsPojo promoCodeActivatedRsPojo
    ) {
        return new GroupPromoCodeActions(groupAdminPermissionValidation, promoCodeService, groupsManager,
                promoCodeActivatedRsPojo);
    }


    @Bean
    public DirectoryActions directoryActions(GroupServicesActualizationService groupServicesActualizationService) {
        return new DirectoryActions(groupServicesActualizationService);
    }

    @Bean
    public UserProductActions productActions(ProductsService productsService) {
        return new UserProductActions(productsService);
    }

    @Bean
    public PromoActions promoActions(PromoService promoService, PromoActivationPreExecutionPolicy preExecutionPolicy,
                                     PromoPojoService promoPojoService) {
        return new PromoActions(promoService, preExecutionPolicy, promoPojoService);
    }

    @Bean
    public PromoAdminActions promoAdminActions(PromoService promoService) {
        return new PromoAdminActions(promoService);
    }

    @Bean
    public PromoCodeActions promoCodeActions(PromoCodeService promoCodeService) {
        return new PromoCodeActions(promoCodeService);
    }

    @Bean
    public UserBillingActions userBillingActions(ProductOwnerDao productOwnerDao, UserBillingService userBillingService,
                                                 OrderDao orderDao, UserServiceManager userServiceManager,
                                                 UserBillingActionsHelper userBillingActionsHelper,
                                                 ReceiptHandlerV1 receiptHandlerV1,
                                                 ReceiptHandlerV2 receiptHandlerV2, TaskScheduler taskScheduler) {
        return new UserBillingActions(productOwnerDao, userBillingService, orderDao, userServiceManager,
                receiptHandlerV1, receiptHandlerV2, userBillingActionsHelper, taskScheduler);
    }

    @Bean
    public MailSupportActions mailSupportActions(
            @Value("${tvm.mailsupport.client-id}") int mailSupportClientId,
            GroupsManager groupsManager, GroupActionsHelper groupActionsHelper,
            UserBillingActionsHelper userBillingActionsHelper,
            SubscriptionService subscriptionService,
            DirectoryClient directoryClient) {
        return new MailSupportActions(mailSupportClientId, groupsManager,
                groupActionsHelper, userBillingActionsHelper,
                subscriptionService, directoryClient);
    }

    @Bean
    public GroupAdminPermissionValidation groupAdminPermissionValidation(
            final DirectoryClient directoryClient,
            final FeatureFlags featureFlags
    ) {
        return new GroupAdminPermissionValidation(directoryClient, featureFlags);
    }

    @Bean
    public GroupValidator groupValidator(final GroupsManager groupsManager) {
        return new GroupValidator(groupsManager);
    }
}
