package ru.yandex.chemodan.app.psbilling.web.config;

import java.util.function.Function;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.ClientBalanceCalculator;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.Settings;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.converter.ToPromoPayloadConverter;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.billing.ClientBalanceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoPayloadParser;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserInfoService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.psbilling.core.util.LanguageService;
import ru.yandex.chemodan.app.psbilling.web.converter.ToGroupPromoConverter;
import ru.yandex.chemodan.app.psbilling.web.converter.ToPromoCodeActivatedRsPojo;
import ru.yandex.chemodan.app.psbilling.web.model.PromoPojo;
import ru.yandex.chemodan.app.psbilling.web.services.PaymentDataService;
import ru.yandex.chemodan.app.psbilling.web.services.ProductsService;
import ru.yandex.chemodan.app.psbilling.web.services.PromoPojoService;
import ru.yandex.chemodan.app.psbilling.web.services.SubscriptionService;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class PsBillingWebServicesConfiguration {
    @Bean
    public SubscriptionService subscriptionService(BalanceService balanceService, GroupsManager groupsManager,
                                                   GroupBillingService groupBillingService,
                                                   GroupServiceDao groupServiceDao,
                                                   GroupProductManager groupProductManager,
                                                   GroupServicesManager groupServicesManager,
                                                   ClientBalanceDao clientBalanceDao,
                                                   ClientBalanceCalculator clientBalanceCalculator,
                                                   PaymentDataService paymentDataService,
                                                   TaskScheduler taskScheduler) {
        return new SubscriptionService(balanceService, groupsManager, groupServicesManager, groupBillingService,
                groupServiceDao, groupProductManager, clientBalanceDao, clientBalanceCalculator, paymentDataService,
                taskScheduler);
    }

    @Bean
    public ProductsService productsService(UserInfoService userInfoService,
                                           TrialService trialService, UserProductManager userProductManager,
                                           UserServiceManager userServiceManager, OrderDao orderDao,
                                           TextsManager textsManager,
                                           TaskScheduler taskScheduler, FeatureFlags featureFlags, Settings settings,
                                           LanguageService languageService,
                                           Function<ToPromoPayloadConverter.ConvertData, Option<String>> toPayload,
                                           Function<ToGroupPromoConverter.ConvertData, Option<PromoPojo>> toGroupPromo
    ) {
        return new ProductsService(userInfoService, trialService, userProductManager,
                userServiceManager, orderDao, textsManager, taskScheduler, featureFlags, settings,
                languageService, toPayload, toGroupPromo);
    }

    @Bean
    public PromoPojoService promoPojoService(PromoPayloadDao promoPayloadDao, PromoPayloadParser promoPayloadParser) {
        return new PromoPojoService(promoPayloadDao, promoPayloadParser);
    }

    @Bean
    public PaymentDataService paymentDataService(BalanceService balanceService, GroupsManager groupsManager,
                                                 @Value("${balance.create-offer.retries}") int createBalanceOfferRetries) {
        return new PaymentDataService(balanceService, groupsManager, createBalanceOfferRetries);
    }

    @Bean
    public Function<ToGroupPromoConverter.ConvertData, Option<PromoPojo>> toGroupPromo(
            Function<ToPromoPayloadConverter.ConvertData, Option<String>> toPayload,
            TextsManager textsManager
    ) {
        return new ToGroupPromoConverter(toPayload, textsManager);
    }

    @Bean
    public ToPromoCodeActivatedRsPojo toPromoCodeActivatedRsPojo() {
        return new ToPromoCodeActivatedRsPojo();
    }
}
