package ru.yandex.chemodan.app.psbilling.web.converter;

import java.util.UUID;

import javax.annotation.Nullable;

import ru.yandex.chemodan.util.exception.NotFoundException;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;

public class ConverterToUUID implements ConverterToType<UUID> {

    @Override
    public UUID convert(@Nullable String s, ActionInvocationContext invocationContext) {
        if (s == null) {
            return null;
        }
        try {
            return UUID.fromString(s);
        } catch (IllegalArgumentException e) {
            throw new NotFoundException("invalid format '" + s + "'");
        }
    }
}

