package ru.yandex.chemodan.app.psbilling.web.converter;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeActivationFail;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeActivationResult;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeActivationType;
import ru.yandex.chemodan.app.psbilling.web.model.PromoCodeActivatedResponsePojo;
import ru.yandex.chemodan.app.psbilling.web.model.PromoCodeFailCodeApi;

@Slf4j
@RequiredArgsConstructor
public class ToPromoCodeActivatedRsPojo {
    public PromoCodeActivatedResponsePojo apply(PromoCodeActivationResult result) {
        if (result.isActivated()) {
            return result.getActivationType()
                    .map(PromoCodeActivationType::getPromoCodeActivationType)
                    .map(type -> new PromoCodeActivatedResponsePojo(true, Option.of(type), Option.empty()))
                    .orElseThrow(() -> new IllegalStateException("Is active promo code without activation type"));
        } else {
            PromoCodeFailCodeApi failCodeApi = result.getFail()
                    .map(PromoCodeActivationFail::getCode)
                    .map(PromoCodeFailCodeApi::fromCoreEnum)
                    .orElseThrow(() -> new IllegalStateException("Is active promo code without error"));

            return new PromoCodeActivatedResponsePojo(false, Option.empty(), Option.of(failCodeApi));
        }
    }
}
