package ru.yandex.chemodan.app.psbilling.web.exceptions;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.balanceclient.exception.BalanceErrorCodeException;
import ru.yandex.chemodan.balanceclient.exception.BalanceException;
import ru.yandex.commune.a3.action.http.HttpStatus;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandlerOrders;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;

public class BalanceExceptionHandler implements ExceptionHandler {
    @Override
    public Option<?> handleException(WebRequest request, ActionInvocationContext context,
                                     ExceptionResolver resolver, Exception exception) {
        if (exception instanceof BalanceException) {
            BalanceException balanceException = (BalanceException) exception;

            if (balanceException instanceof BalanceErrorCodeException &&
                    ((BalanceErrorCodeException) balanceException).getCodes()
                            .find(BalanceErrorCodeException.BalanceErrorCode::isKnown).isPresent()) {
                BalanceErrorCodeException errorCodeException = (BalanceErrorCodeException) balanceException;
                context.getHttpContext().setStatusCode(HttpStatus.BAD_REQUEST.getStatusCode());
                return Option.of(ErrorResult.fromNameAndThrowable(errorCodeException.concatenatedCodes(), exception));
            } else {
                context.getHttpContext().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode());
                return Option.of(ErrorResult.fromNameAndThrowable("balance_error", exception));
            }
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return ExceptionHandlerOrders.CUSTOM_EXCEPTION_HANDLER_ORDER;
    }
}
