package ru.yandex.chemodan.app.psbilling.web.exceptions;

import ru.yandex.commune.a3.action.http.HttpStatus;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.commune.a3.action.result.error.ErrorNameSource;

public class WebActionException extends RuntimeException implements HttpStatusCodeSource, ErrorNameSource {
    private int httpStatusCode;
    private String errorCode;

    public WebActionException(int httpStatus, String errorCode, String message) {
        super(message);
        this.httpStatusCode = httpStatus;
        this.errorCode = errorCode;
    }

    public WebActionException(int httpStatus, String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.httpStatusCode = httpStatus;
        this.errorCode = errorCode;
    }

    @Override
    public int getHttpStatusCode() {
        return httpStatusCode;
    }

    @Override
    public String getErrorName() {
        return errorCode;
    }

    public static WebActionException cons500(String message, Throwable cause) {
        return new WebActionException(
                HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode(), CommonErrorNames.INTERNAL, message, cause);
    }

    public static WebActionException cons500(String message) {
        return new WebActionException(
                HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode(), CommonErrorNames.INTERNAL, message);
    }

    public static WebActionException cons400(String code, String message, Throwable cause) {
        return new WebActionException(HttpStatus.BAD_REQUEST.getStatusCode(), code, message, cause);
    }

    public static WebActionException cons400(String code, String message) {
        return new WebActionException(HttpStatus.BAD_REQUEST.getStatusCode(), code, message);
    }

    public static WebActionException cons404(String code, String message) {
        return new WebActionException(HttpStatus.NOT_FOUND.getStatusCode(), code, message);
    }

    public static WebActionException cons400(String message) {
        return new WebActionException(HttpStatus.BAD_REQUEST.getStatusCode(), CommonErrorNames.VALIDATE, message);
    }

    public static WebActionException cons402(String message) {
        return new WebActionException(HttpStatus.PAYMENT_REQUIRED.getStatusCode(), CommonErrorNames.VALIDATE, message);

    }

}
