package ru.yandex.chemodan.app.psbilling.web.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.products.UserProduct;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@NoArgsConstructor
@Getter
public abstract class AbstractUserProductPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("product_id")
    private String productId;
    @JsonProperty("product_id_family")
    private String productIdFamily;
    @JsonProperty("title")
    private String title;
    @JsonProperty("best_offer")
    private boolean bestOffer;
    @JsonProperty("product_type")
    private UserProductTypeApi productType;
    @JsonProperty("features")
    private List<FeaturePojo> features;
    @JsonProperty("trial")
    private Option<TrialPojo> trial;

    public AbstractUserProductPojo(UserProduct product, String title, List<FeaturePojo> features)
    {
        this.productId = product.getCode();
        this.productIdFamily = product.getCodeFamily();
        this.title = title;
        this.bestOffer = product.isBestOffer();
        this.productType = UserProductTypeApi.fromCoreEnum(product.getBillingType());
        this.features = features;
        this.trial = product.getTrialDefinition().map(TrialPojo::new);
    }
}
