package ru.yandex.chemodan.app.psbilling.web.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.ToString;

import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.chemodan.web.JacksonPojo;

@Getter
@ToString
public class ActivatePromoCodePayload implements JacksonPojo {
    private final SafePromoCode promoCode;

    @JsonCreator
    public ActivatePromoCodePayload(
            @JsonProperty("promo_code") String promoCode
    ) {
        this.promoCode = SafePromoCode.cons(promoCode);
    }
}
