package ru.yandex.chemodan.app.psbilling.web.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.balance.Address;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@NoArgsConstructor
public class AddressPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("postcode")
    private String postcode;
    @JsonProperty("address")
    private String address;

    public AddressPojo(Address address) {
        this(address.getPostcode(), address.getAddress());
    }
}
