package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriodUnit;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.lang.Validate;

public enum CustomPeriodApi implements StringEnum {
    //для тестирования
    ONE_SECOND("second", CustomPeriodUnit.ONE_SECOND),
    //для тестирования продления и прочего, деаем 10 минуные продукты, но фронт их будет обображать как месячные
    ONE_MONTH("month", CustomPeriodUnit.ONE_MONTH, CustomPeriodUnit.TEN_MINUTES),
    ONE_YEAR("year", CustomPeriodUnit.ONE_YEAR),
    ONE_WEEK("week", CustomPeriodUnit.ONE_WEEK),
    ONE_DAY("day", CustomPeriodUnit.ONE_DAY),
    ONE_HOUR("hour", CustomPeriodUnit.ONE_HOUR),
    ONE_MINUTE("minute", CustomPeriodUnit.ONE_MINUTE);

    private final String value;
    private final SetF<CustomPeriodUnit> coreEnums;
    private static final MapF<CustomPeriodUnit, CustomPeriodApi> coreToWeb = Cf.hashMap();

    static {
        MapF<CustomPeriodUnit, ListF<CustomPeriodApi>> mappings = Cf.x(CustomPeriodApi.values())
                .map(w -> w.coreEnums.map(c -> Tuple2.tuple(c, w)))
                .flatMap(Function.identityF())
                .groupBy(Tuple2::get1)
                .mapValues(l -> l.map(Tuple2::get2));
        mappings.values().forEach(l -> Validate.sizeIs(1, l));

        coreToWeb.putAll(mappings.mapValues(ListF::first));
    }

    CustomPeriodApi(String value, CustomPeriodUnit... coreEnums) {
        this.value = value;
        this.coreEnums = Cf.set(coreEnums);
    }

    @Override
    public String value() {
        return value;
    }

    public static CustomPeriodApi fromCoreEnum(CustomPeriodUnit type) {
        return coreToWeb.getOrThrow(type);
    }
}
