package ru.yandex.chemodan.app.psbilling.web.model;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupStatus;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class GroupPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("group_id")
    private String groupId;
    @JsonProperty("group_type")
    private GroupTypeApi groupType;
    @JsonProperty("next_billing_date")
    private Option<Instant> nextBillingDate;
    @JsonProperty("payment_period_end_date")
    private Option<Instant> paymentPeriodEndDate;
    @JsonProperty("status")
    private GroupStatusApi status;
    @JsonProperty("payers_uids")
    private List<String> payersUids;
    @JsonProperty("balance_amount")
    private ListF<BalanceAmount> balanceAmounts;
    @JsonProperty("balance_void_date")
    private Option<Instant> balanceVoidDate;
    @JsonProperty("auto_billing_enabled")
    private boolean autoBillingEnabled;

    @AllArgsConstructor
    @Getter
    public static class BalanceAmount {
        @JsonProperty("amount")
        private BigDecimal amount;
        @JsonProperty("currency")
        private String currency;
        @JsonProperty("void_date")
        private Option<Instant> voidDate;
    }

    public GroupPojo(Group group, GroupStatus groupStatus, ListF<PassportUid> groupPayers,
                     List<GroupService> activeGroupServices,
                     Instant nextBillingDate, Option<Instant> paymentPeriodEndDate,
                     ListF<BalanceAmount> balanceAmounts,
                     boolean autoBillingEnabled) {
        this.groupId = group.getExternalId();
        this.groupType = GroupTypeApi.fromCoreEnum(group.getType());
        //отображаем дату списания только если есть активные сервисы.
        this.nextBillingDate = activeGroupServices.isEmpty() ? Option.empty() : Option.of(nextBillingDate);
        //отображаем дату окончания оплаты только если есть сумма к списанию
        this.paymentPeriodEndDate = paymentPeriodEndDate;
        this.status = GroupStatusApi.fromCoreEnum(groupStatus);
        this.payersUids = Lists.newArrayList(groupPayers.map(PassportUid::toString));
        this.balanceAmounts = balanceAmounts;
        this.autoBillingEnabled = autoBillingEnabled;
    }
}
