package ru.yandex.chemodan.app.psbilling.web.model;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupProductType;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.TrialUsage;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProduct;
import ru.yandex.chemodan.app.psbilling.core.products.TrialDefinition;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@NoArgsConstructor
public class GroupProductPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("product_id")
    private String productId;
    @JsonProperty("price_per_user_in_month")
    private BigDecimal pricePerUserInMonth;
    @JsonProperty("display_original_price_per_user_in_month")
    private Option<BigDecimal> displayOriginalPricePerUserInMonth;
    @JsonProperty("display_discount_percent")
    private Option<BigDecimal> displayDiscountPercent;
    @JsonProperty("currency")
    private String currency;
    @JsonProperty("trial")
    private Option<TrialPojo> trial;
    @JsonProperty("title")
    private String title;
    @JsonProperty("features")
    private List<FeaturePojo> features;
    @JsonProperty("best_offer")
    private boolean bestOffer;
    @JsonProperty("payment_type")
    private String paymentType;
    @JsonProperty("product_family")
    private String codeFamily;
    @JsonProperty("product_type")
    private String productType;
    @JsonProperty("available_addons")
    private List<String> availableAddons;


    public GroupProductPojo(
            GroupProduct product,
            String title,
            List<FeaturePojo> features,
            Function<TrialDefinition, TrialService.TrialAvailability> trialAvailabilityChecker) {
        this.productId = product.getCode();
        this.currency = product.getPriceCurrency().getCurrencyCode();
        this.pricePerUserInMonth = product.getPricePerUserInMonth();
        this.displayOriginalPricePerUserInMonth = product.getDisplayOriginalPrice();
        this.displayDiscountPercent = product.getDisplayDiscountPercent();
        this.title = title;
        this.features = features;
        this.bestOffer = product.isBestOffer();
        this.trial = product.getTrialDefinition().filterNot(TrialDefinition::isHidden)
                .map(definition -> {
                    TrialService.TrialAvailability availability = trialAvailabilityChecker.apply(definition);
                    return new TrialPojo(definition, availability.isAvailable(),
                            availability.getUsage().map(TrialUsage::getEndDate));
                });
        this.paymentType = product.getPaymentType().value();
        this.codeFamily = product.getUserProduct().getCodeFamily();
        this.productType = product.getProductType().value();
        if (product.getProductType() == GroupProductType.MAIN) {
            this.availableAddons = product.getAvailableAddons().map(GroupProduct::getCode);
        }
    }
}
