package ru.yandex.chemodan.app.psbilling.web.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class GroupServicePojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("id")
    private String groupServiceId;
    @JsonProperty("status")
    private ServiceStatus state;
    @JsonProperty("creation_date")
    private Instant creationDate;
    @JsonProperty("next_billing_date")
    private Option<Instant> nextBillingDate;
    @JsonProperty("product")
    private GroupProductPojo product;
    @JsonProperty("is_free")
    private Boolean isFree;
    @JsonProperty("price_overrides")
    private List<PriceOverridesPojo> priceOverrides;
    @JsonProperty("disabled_date")
    private Option<Instant> actualDisabledAt;
}
