package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupStatus;

public enum GroupStatusApi {
    ACTIVE(GroupStatus.ACTIVE),
    PAYMENT_REQUIRED(GroupStatus.PAYMENT_REQUIRED),
    DEBT_EXISTS(GroupStatus.DEBT_EXISTS);

    private GroupStatus coreEnum;

    private static final MapF<GroupStatus, GroupStatusApi>
            coreToWeb =
            Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(GroupStatusApi.values()).toMap(v -> v.coreEnum, Function.identityF()));
    }

    GroupStatusApi(GroupStatus coreEnum) {
        this.coreEnum = coreEnum;
    }

    public GroupStatus toCoreEnum() {
        return coreEnum;
    }

    public static GroupStatusApi fromCoreEnum(GroupStatus type) {
        return coreToWeb.getOrThrow(type);
    }
}
