package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;
import ru.yandex.misc.enums.StringEnum;

public enum GroupTypeApi implements StringEnum {
    ORGANIZATION("organization", GroupType.ORGANIZATION),
    FAMILY("family", GroupType.FAMILY),
    STAFF("staff", GroupType.STAFF),
    ORGANIZATION_USER("organization_user", GroupType.ORGANIZATION_USER);

    private final String value;
    private final GroupType coreEnum;
    private static final MapF<GroupType, GroupTypeApi> coreToWeb =
            Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(GroupTypeApi.values()).toMap(v -> v.coreEnum, Function.identityF()));
    }

    GroupTypeApi(String value, GroupType coreEnum) {
        this.value = value;
        this.coreEnum = coreEnum;
    }

    @Override
    public String value() {
        return value;
    }

    public GroupType toCoreEnum() {
        return coreEnum;
    }

    public static GroupTypeApi fromCoreEnum(GroupType type) {
        return coreToWeb.getOrThrow(type);
    }
}
