package ru.yandex.chemodan.app.psbilling.web.model;

import java.math.BigDecimal;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
public class GroupsByPayerResponsePojo  extends DefaultObject implements JacksonPojo {
    @JsonProperty("groups")
    public ListF<GroupsByPayerPojo> groups;

    @Getter
    @AllArgsConstructor
    public static class GroupsByPayerPojo {
        @JsonProperty("group_id")
        private Integer groupId;
        @JsonProperty("services")
        private ListF<GroupByPayerServicePojo> services;
    }

    @AllArgsConstructor
    @Getter
    public static class GroupByPayerServicePojo {
        @JsonProperty("id")
        private UUID id;
        @JsonProperty("product_name")
        private Option<String> productName;
        @JsonProperty("price_per_user_in_month")
        private BigDecimal pricePerUserInMonth;
        @JsonProperty("currency")
        private String currency;
        @JsonProperty("payment_type")
        private String paymentType;
    }
}
