package ru.yandex.chemodan.app.psbilling.web.model;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.chemodan.app.psbilling.core.entities.users.Order;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

public class InappOrderPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("order_id")
    private String orderId;
    @JsonProperty("user_service_id")
    private String userServiceId;

    public InappOrderPojo(Order order) {
        this.orderId = order.getId().toString();
        this.userServiceId = order.getUserServiceId().map(UUID::toString).getOrNull();
    }
}
