package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.chemodan.app.psbilling.core.entities.InappStore;
import ru.yandex.misc.enums.StringEnum;

public enum InappStoreTypeApi implements StringEnum {
    APPLE_APPSTORE("APPLE_APPSTORE", InappStore.APPLE_APPSTORE),
    GOOGLE_PLAY("GOOGLE_PLAY", InappStore.GOOGLE_PLAY);

    private final String value;
    private final InappStore coreStoreType;

    InappStoreTypeApi(String value, InappStore inappStore) {
        this.value = value;
        this.coreStoreType = inappStore;
    }

    @Override
    public String value() {
        return value;
    }

    public InappStore toCoreEnum() {
        return coreStoreType;
    }
}
